/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.util.ObjectUtil;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public final class CommonUtil {
    private static boolean isDoubleClickRegistered;

    private CommonUtil() {
    }

    public static IToken getToken(String tokenName) {
        return new Token((Object)tokenName);
    }

    public static synchronized void handleOpenWithEditorPref() {
        IViewPart explorerPart;
        if (!isDoubleClickRegistered && (explorerPart = UIUtils.findView((String)"org.eclipse.ui.navigator.ProjectExplorer")) != null) {
            CommonNavigator projectExplorer = (CommonNavigator)explorerPart;
            CommonViewer viewer = projectExplorer.getCommonViewer();
            viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IResource selectedResource = UIUtils.getSelectedResource();
                    if (!(selectedResource instanceof IFile)) {
                        return;
                    }
                    IFile selectedFile = (IFile)selectedResource;
                    if (selectedFile.getFileExtension() == null) {
                        String selectedEditor = Platform.getPreferencesService().getString("com.aptana.editor.common", "com.aptana.editor.common.openWithEditor", "", null);
                        if (selectedEditor != "Default Editor") {
                            IDE.setDefaultEditor((IFile)selectedFile, (String)selectedEditor);
                        }
                    } else if (selectedFile.getFileExtension().equals("xml")) {
                        boolean isView;
                        IContainer parent = selectedResource.getParent();
                        boolean bl = isView = parent != null && parent.getName().equals("views");
                        if (!isView) {
                            boolean bl2 = isView = (parent = parent.getParent()) != null && parent.getName().equals("views");
                        }
                        if (isView) {
                            IDE.setDefaultEditor((IFile)selectedFile, (String)CommonUtil.getSelectedEditor());
                        } else if (selectedFile.getName().equals("tiapp.xml")) {
                            IDE.setDefaultEditor((IFile)selectedFile, (String)"com.appcelerator.titanium.ui.ide.tiappEditor");
                        } else if (selectedFile.getName().equals("tiapp.xml")) {
                            IDE.setDefaultEditor((IFile)selectedFile, (String)"com.appcelerator.titanium.ui.ide.tiappEditor");
                        } else {
                            IDE.setDefaultEditor((IFile)selectedFile, (String)"com.aptana.editor.xml.alloy");
                        }
                    }
                }
            });
            isDoubleClickRegistered = true;
        }
    }

    private static String getSelectedEditor() {
        if (ObjectUtil.areEqual((Object)UIUtils.getActivePerspectiveId(), (Object)"com.appcelerator.titanium.perspective.designer")) {
            return "visualui.editors.ScratchPadEditor";
        }
        return "com.aptana.editor.xml.alloy";
    }
}

